/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ras;

import com.ibm.ras.RASFileHandler;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIFormatter;
import com.ibm.ras.RASIMessageEvent;
import com.ibm.ras.RASITraceEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class MultiFileHandler
extends RASFileHandler
implements RASIMessageEvent,
RASITraceEvent {
    private static final String KEY_CLIENT = "foobar";
    private String prefix = "Message";
    private Hashtable printWriters = new Hashtable();
    private Hashtable fileNames = new Hashtable();
    private Hashtable maxSizeTable = new Hashtable();
    private Hashtable maxFileTable = new Hashtable();
    private String baseDir = "";
    private boolean multiDir = false;
    private int maxFiles = 10;
    private int maxFileSize = 2048;

    public MultiFileHandler() {
        this("", "");
    }

    public MultiFileHandler(String string) {
        this(string, "");
    }

    public MultiFileHandler(String string, String string2) {
        super(string, string2);
    }

    public void setBaseDirectory(String string) {
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        this.baseDir = string;
    }

    public String getBaseDirectory() {
        return this.baseDir;
    }

    public void setMaxFileSize(int n) {
        this.maxFileSize = n;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFiles(int n) {
        this.maxFiles = n;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMultiDir(boolean bl) {
        this.multiDir = bl;
    }

    public boolean isMultiDir() {
        return this.multiDir;
    }

    private void checkFile(RASIEvent rASIEvent) throws IOException {
        String string;
        if (this.multiDir && rASIEvent.getAttribute(KEY_CLIENT) != "") {
            string = String.valueOf(this.baseDir) + File.separator + rASIEvent.getAttribute(KEY_CLIENT) + File.separator;
            this.pWriter = (PrintWriter)this.printWriters.get(rASIEvent.getAttribute(KEY_CLIENT));
            this.setFileName((String)this.fileNames.get(rASIEvent.getAttribute(KEY_CLIENT)));
        } else {
            string = this.baseDir;
        }
        if (this.pWriter == null || new File(this.getFileName()).length() >= (long)this.maxFileSize) {
            1 var4_4;
            String[] stringArray;
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((stringArray = file.list(var4_4 = new 1())).length == 0) {
                try {
                    this.pWriter = new PrintWriter(new FileOutputStream(String.valueOf(file.getPath()) + this.prefix + "1.log"), true);
                    this.setFileName(String.valueOf(file.getPath()) + this.prefix + "1.log");
                    if (rASIEvent.getAttribute(KEY_CLIENT) != "" && this.multiDir) {
                        this.fileNames.put(rASIEvent.getAttribute(KEY_CLIENT), String.valueOf(file.getPath()) + this.prefix + "1.log");
                        this.printWriters.put(rASIEvent.getAttribute(KEY_CLIENT), this.pWriter);
                    }
                    return;
                }
                catch (IOException iOException) {
                    System.err.println("An error occurred while attempting to open the trace log file " + file.getPath() + this.prefix + "1.log");
                    iOException.printStackTrace();
                    throw iOException;
                }
            }
            if (stringArray.length != this.maxFiles) {
                int n = stringArray.length + 1;
                File file2 = new File(String.valueOf(file.getPath()) + this.prefix + new Integer(n).toString() + ".log");
                while (file2.exists() && n != 0) {
                    file2 = new File(String.valueOf(file.getPath()) + this.prefix + --n + ".log");
                }
                try {
                    this.pWriter = new PrintWriter(new FileOutputStream(file2), true);
                    this.setFileName(file2.getAbsolutePath());
                    if (rASIEvent.getAttribute(KEY_CLIENT) != "" && this.multiDir) {
                        this.printWriters.put(rASIEvent.getAttribute(KEY_CLIENT), this.pWriter);
                        this.fileNames.put(rASIEvent.getAttribute(KEY_CLIENT), file2.getAbsolutePath());
                    }
                    return;
                }
                catch (IOException iOException) {
                    System.err.println("An error occurred while attempting to open the trace log file " + file.getPath() + this.prefix + "1.log");
                    iOException.printStackTrace();
                    throw iOException;
                }
            }
            String string2 = String.valueOf(file.getPath()) + stringArray[0];
            long l = new File(String.valueOf(file.getPath()) + stringArray[0]).lastModified();
            int n = 0;
            while (n < stringArray.length) {
                if (new File(String.valueOf(file.getPath()) + stringArray[n]).lastModified() < l) {
                    l = new File(String.valueOf(file.getPath()) + stringArray[n]).lastModified();
                    string2 = String.valueOf(file.getPath()) + stringArray[n];
                }
                ++n;
            }
            File file3 = new File(string2);
            file3.delete();
            try {
                this.setFileName(string2);
                this.pWriter = new PrintWriter(new FileOutputStream(string2), true);
                if (rASIEvent.getAttribute(KEY_CLIENT) != "" && this.multiDir) {
                    this.printWriters.put(rASIEvent.getAttribute(KEY_CLIENT), this.pWriter);
                    this.fileNames.put(rASIEvent.getAttribute(KEY_CLIENT), string2);
                }
                return;
            }
            catch (IOException iOException) {
                System.err.println("An error occurred while attempting to open the trace log file " + file.getPath() + this.prefix + "1.log");
                iOException.printStackTrace();
                throw iOException;
            }
        }
    }

    public void writeEvent(RASIEvent rASIEvent) {
        try {
            this.checkFile(rASIEvent);
        }
        catch (IOException iOException) {
            return;
        }
        RASIFormatter rASIFormatter = this.findFormatter(rASIEvent);
        if (rASIFormatter != null) {
            String string = rASIFormatter.format(rASIEvent);
            this.pWriter.println(string);
        }
    }

    private final class 1
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.startsWith(MultiFileHandler.this.prefix) && string.endsWith(".log");
        }

        /* synthetic */ 1() {
        }
    }
}

